###############################################################################
# NotifyPlus.pl                                                               #
###############################################################################
# YaBB: Yet another Bulletin Board                                            #
# Open-Source Project started by Zef Hemel (zef@zefnet.com)                   #
# Software Version: YaBB 1 Gold - Release                                     #
# =========================================================================== #
# Software Distributed by:    http://yabb.xnull.com                           #
# Support, News, Updates at:  http://yabb.xnull.com/community/                #
# =========================================================================== #
# Copyright (c) 2000-2001 X-Null - All Rights Reserved                        #
# Software by: The YaBB Development Team                                      #
###############################################################################
# Mod name: Notify Plus 3.0 SP1.31                                            # 
# by      : Sonic (Previous version by D2N)                                   #
###############################################################################

require "$sourcedir/Lite.pm";

# =============================================================================
# SendTopic
# =============================================================================
sub NP_SendTopic {

	# Type of posting
	local($post_type) = @_;

	# Get style- & body-tag from template.html
	&ReadTemplate;

	# Read all required Member-data
	&ReadAllMembers;
	
	# Fill message	
	$message = $FORM{'message'};

	# Type of Post
	if ($post_type eq "thread") {
		$post_message = $notify_txt{'5'};
	}
	else {
		$post_message = $notify_txt{'49'};	
	}
	
	# -----------------------------------------------------------------------------			
	# Plain text message			
	# -----------------------------------------------------------------------------		
	# Replace the <br>'s with \n's
	$PLAINmessage = $message;					
	$PLAINmessage =~ s/<br>/\n/gi;
	&FromHTML($PLAINmessage);	
					
	# Compose the message
	$thePLAINmessage = << "EOT";

$notify_txt{'4'}

$post_message
$notify_txt{'6'} $notify_txt{'7'}:
$cgi;action=display;num=$thread

$notify_txt{'11'}

$notify_txt{'12'}

-----------------------------------------------------------------------------
$FORM{'subject'}
$notify_txt{'8'} $FORM{'name'} $notify_txt{'9'} $date
-----------------------------------------------------------------------------
$PLAINmessage
-----------------------------------------------------------------------------							
$notify_txt{'10'}:
$cgi;action=post;num=$thread;title=$txt{'116'};start=$start

EOT

	# -----------------------------------------------------------------------------			
	# HTML message
	# -----------------------------------------------------------------------------						
	# Replace the \n's with <br>'s
	$HTMLmessage = $message;
	$HTMLmessage =~ s/\n/<br>/gi;

	# -----------------------------------------------------------------------------							
	# Compose the message (part 1)
	# -----------------------------------------------------------------------------						
	$theHTMLmessage_part1 = << "EOT";
				
<html>
<head>
<title>$FORM{'subject'}</title>
EOT
			
	# Print Style
	foreach $line (@style) {
		$theHTMLmessage_part1 .= $line;
	}
	
	$theHTMLmessage_part1 .= << "EOT";
</head>
$body
				
<table border="0">
<tr>
	<td>
		<font size="2">
		$notify_txt{'4'}
		<p>
		$post_message<br>
		<a href='$cgi;action=display;num=$thread'>$notify_txt{'6'}</a> $notify_txt{'7'}.
		<p>
		$notify_txt{'11'}
		<p>
		$notify_txt{'12'}
		</font>
	</td>	
</tr>		
</table>		
<p>
<table width="100%" border="0">
<tr>
	<td align="left" valign="middle" colspan="2">
		<hr width="100%" size="2" color="#000000" class="windowbg3">
	</td>
</tr>		
<tr>
    <td align="left" valign="middle">
EOT

	# -----------------------------------------------------------------------------							
	# Compose the message (part 2)
	# -----------------------------------------------------------------------------						
	$theHTMLmessage_part2 .= << "EOT";	

	</td>
	<td align="left" valign="middle">
 	   <font size="2"><b>$FORM{'subject'}</b></font> &nbsp;<br>
       <font size="1">&#171; <b>$notify_txt{'8'} <a href="mailto:$FORM{'email'}">$FORM{'name'}</a> $notify_txt{'9'} </b> $date &#187;</font>
	</td>
</tr>
<tr>
	<td align="left" valign="middle" colspan="2">
		<hr width="100%" size="1" color="$color{'windowbg3'}" class="windowbg3">
		<font size="2">
EOT
	# -----------------------------------------------------------------------------							
	# Compose the message (part 3)
	# -----------------------------------------------------------------------------						
	$theHTMLmessage_part3 .= << "EOT";
		</font>
	</td>
</tr>
<tr>
	<td align="left" valign="middle" colspan="2">
 		<hr width="100%" size="2" color="#000000" class="windowbg3">
	</td>
</tr>	
<tr>
	<td align="left" colspan="2">
 		<a href="$cgi;action=post;num=$thread;title=$txt{'116'};start=$start">
EOT

	# -----------------------------------------------------------------------------							
	# Compose the message (part 4)
	# -----------------------------------------------------------------------------						
	$theHTMLmessage_part4 .= << "EOT";		
</a>
	</td>
</tr>		
</table>
			
</body>
</html>
EOT
	
	# When UBBC enabled
	# Save message ...
	$save_message = $message;
	
	# HTML, images not included
	if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; } 

	$theHTMLmessage = $theHTMLmessage_part1;
	$theHTMLmessage .= "<img src=\"$imagesdir/$FORM{'icon'}.gif\">" . $theHTMLmessage_part2;	
	$theHTMLmessage .= $message . $theHTMLmessage_part3;
	$theHTMLmessage .= "$img{'reply'}" . $theHTMLmessage_part4;	
	
	# Write message.html
	fopen(FILE, ">$vardir/message.html");
	print FILE "$theHTMLmessage";
	fclose(FILE);
		
	# HTML, images included (first restore message ...)
	$message = $save_message;
	if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC("IncludeImage"); } 	
	$theHTMLmessage_include = $theHTMLmessage_part1;
	$theHTMLmessage_include .= "<img src=\"$imagesurl/$FORM{'icon'}.gif\">" . $theHTMLmessage_part2;	
	$theHTMLmessage_include .= $message . $theHTMLmessage_part3;
	$theHTMLmessage_include .= "$img{'reply'}" . $theHTMLmessage_part4;

	# -----------------------------------------------------------------------------			
	# Read all notified Members
	# -----------------------------------------------------------------------------						
	# Read all records 
	foreach $record (@mails) {
	
		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		chomp($format);	

		# Determine Format
		if ($format eq "") {		

			# Read User Data
			$user_to_read =	$user_Array{"$email"};
			&ReadUserData($user_to_read);
		}
		else {	
			$user_format =	$format;
			$user_includeimg =	0;			
		}	

		# Do not send to Poster
		if ($email ne $settings[2]) {								
		
			# -----------------------------------------------------------------------------								
			# Send the email
			# -----------------------------------------------------------------------------	
			# Fill Subject 
			$subject = "$txt{'127'}\:  $FORM{'subject'}";
			&SendMail($email);
		}
		
	# End Foreach
	}
}

# =============================================================================
# ReadHTML
# =============================================================================
sub ReadHTML {

	# Define Arrays
	@images = ();
	@cid = ();	

	# Define Variables
	$counter = 0;	 	
	
	# Are there image(s) in this line (not starting with http://) ?
	$imgpos1 = index($theHTMLmessage_include, "<img", 0);
	$imgpos2 = index($theHTMLmessage_include, "src=", 0);	

	# -----------------------------------------------------------------------------					
	# Image found !!
	# -----------------------------------------------------------------------------						
	if ($imgpos1 != -1 && $imgpos2 != -1) {
	
		# First character
		$counter = $counter + 1;
		$newHTMLmessage = "";
		$char = substr($theHTMLmessage_include, $counter, 1);
	
		# Search for image-source(s)
		while ($counter <= length($theHTMLmessage_include)) {		

			# -----------------------------------------------------------------------------							
			# Image-source between quotes
			# -----------------------------------------------------------------------------					
			if (substr($theHTMLmessage_include, $counter, 5) eq "src=\"") {
					
				# First char
				$imgsrc = "";
				$counter = $counter + 5;
				$char = substr($theHTMLmessage_include, $counter, 1);
					
				# Read image-source
				while ($char ne "\"") {		
					$imgsrc .= $char;							
					$counter = $counter + 1;
					$char = substr($theHTMLmessage_include, $counter, 1);
				}
		
				# New HTML-message
				if (substr($imgsrc, 0, 4) ne "http") {
					$GeneratedCID = GenerateCID();
					$newHTMLmessage .= "<img src=\"cid:" . $GeneratedCID;
					push(@images, $imgsrc);
					push(@cid, $GeneratedCID);					
				}
				else {
					$newHTMLmessage .= "<img src=\"" . $imgsrc;
				}
			}	
			# -----------------------------------------------------------------------------							
			# Image-source not between quotes				
			# -----------------------------------------------------------------------------							
			elsif (substr($theHTMLmessage_include, $counter, 4) eq "src=") {
					
				# First char
				$imgsrc = "";				
				$counter = $counter + 4;
				$char = substr($theHTMLmessage_include, $counter, 1);
				
				# Read image-source
				while ($char ne ">") {		
					$imgsrc .= $char;							
					$counter = $counter + 1;
					$char = substr($theHTMLmessage_include, $counter, 1);
				}

				# New HTML-message
				if (substr($imgsrc, 0, 4) ne "http") {
					$GeneratedCID = GenerateCID();
					$newHTMLmessage .= "<img src=cid:" . $GeneratedCID;
					push(@images, $imgsrc);
					push(@cid, $GeneratedCID);						
				}
				else {
					$newHTMLmessage .= "<img src=" . $imgsrc;
				}				
			}
			# -----------------------------------------------------------------------------							
			# Normal text (between image-sources)				
			# -----------------------------------------------------------------------------							
			else {
					# New HTML-message
					$newHTMLmessage .= $char;	
					$counter = $counter + 1;
					$char = substr($theHTMLmessage_include, $counter, 1);
			}
				
		# End while	
		}
	}	

	# -----------------------------------------------------------------------------								
	# No Image found !!
	# -----------------------------------------------------------------------------									
	else {
			
		# New HTML-message
		$newHTMLmessage .= $theHTMLmessage_include;	
	}
}

# =============================================================================
# GenerateCID
# =============================================================================
sub GenerateCID {
	return(int(time).rand().rand());
}

# =============================================================================
# SendMail
# =============================================================================
sub SendMail {

	# Email address to send to
	local($email_to) = @_;
		
	# -----------------------------------------------------------------------------			
	# Sendmail or SMTP ?!
	# -----------------------------------------------------------------------------	
	# Set Sendmail or SMTP
	if ($mailtype == 0) {
	
		# Sendmail
		# -t	Scan message for To:, Cc:, Bcc:, etc.
        # -oi	Do NOT treat a single "." on a line as a message terminator.
		# -oem	On error, mail back the message
		$sendmail = $mailprog . " -t -oi -oem";
		MIME::Lite->send('sendmail', $sendmail);
	}
	else {
		# SMTP	
		MIME::Lite->send('smtp', $smtp_server, Timeout=>60);
	}

	# -----------------------------------------------------------------------------			
	# Send message in Plain Text
	# -----------------------------------------------------------------------------						
	if ($user_format eq "Plain") {
		$msg = MIME::Lite->new(
				From    => $webmaster_email,
			    To      => $email_to,
				Subject => $subject,
				Data     => $thePLAINmessage
				);		
		# Send !
		$msg->send;							
	}
	# -----------------------------------------------------------------------------			
	# Send message in Normal HTML
	# -----------------------------------------------------------------------------						
	elsif ($user_format eq "HTML") {
		
		# Include messages ?
		# Include
		if ($user_includeimg == 1) {

			# -----------------------------------------------------------------------------			
			# Make special message with CID's
			# -----------------------------------------------------------------------------											
			&ReadHTML;

			$msg = MIME::Lite->new(
				From    => $webmaster_email,
			    To      => $email_to,
				Subject => $subject,
				Type    => 'multipart/related'
				);

			$msg->attach(
					Type => 'text/html',
					Data => $newHTMLmessage
					);

			# When images
			if (@images) {
				
				# Attach all images
				$counter = 0;
				foreach $image (@images) {		

					$msg->attach(
							Type => 'image/gif',
							Id   => @cid[$counter],
							Path => $image
							);		
					++$counter;					
				}
			}
																									
			# Send !
			$msg->send;	
		}
		# Do not include					
		else {
			$msg = MIME::Lite->new(
					From    => $webmaster_email,
				    To      => $email_to,
					Subject => $subject,
					Type    => 'multipart/related'				 
					);
					$msg->attach(
					Type => 'text/html',
					Data => $theHTMLmessage
					);  
			# Send !
			$msg->send;								
		}
	}
	# -----------------------------------------------------------------------------			
	# Send message in Plain Text with HTML-file attached
	# -----------------------------------------------------------------------------			
	else {
		$msg = MIME::Lite->new( 
				From    => $webmaster_email,
				To      => $email_to,
				Subject => $subject,
				Type    => 'multipart/mixed'
				);
 
		$msg->attach(
				Type     => 'TEXT',   
				Data     => $thePLAINmessage
				);
		
		$file = "message.html";		  
		$path = $vardir . "/" . $file;	
		$msg->attach(
				Type     => 'text/html',
				Path     => $path,
				Filename => $file,							
				Disposition => 'attachment'
				);
		# Send !							
		$msg->send;
		
	# End if Plain/HTML/HTML-Attach	
	}
		
# End if Do not send to Poster
}	

# =============================================================================
# ReadUserData
# =============================================================================
sub ReadUserData {
	
	# User to read data of
	local($usertoread) = @_;	

		# Determine Membergroup
		fopen(FILE, "$memberdir/$usertoread.dat");
		@usersettings=<FILE>;
		fclose(FILE);
		$user_name = $usersettings[1];		
		$user_membergroup = $usersettings[7];
		$user_email = $usersettings[2];
		chomp($user_name);		
		chomp($user_membergroup);
		chomp($user_email);		

		# Determine Format & Include images	
		fopen( FILE, "$memberdir/$usertoread.da2");
		@usersettings2=<FILE>;
		fclose(FILE);
		$user_format = $usersettings2[0];
		$user_includeimg = $usersettings2[1];
		chomp($user_format);
		chomp($user_includeimg);		
}

# =============================================================================
# ReadAllMembers
# =============================================================================
sub ReadAllMembers {

	# Open Memberlist
	fopen(FILE, "$memberdir/memberlist.txt");
	@memberlist = <FILE>;
	fclose(FILE);

	# Read details of each Member	
	foreach $member (@memberlist) {
		chomp($member);
		
		fopen(FILE, "$memberdir/$member.dat");
		@usersettings = <FILE>;
		fclose(FILE);

		# Get user-email and store in Array
		$user_email = $usersettings[2];
		chomp($user_email);
		$user_Array{"$user_email"} = $member;
	}	
}

# =============================================================================
# ShowBoards
# =============================================================================
sub ShowBoards {

	# Read Mailinglist File
	fopen(FILE, "$vardir/mailinglist.txt");
	@mailinglist = <FILE>;
	fclose (FILE);			

	# -----------------------------------------------------------------------------
	# Read the mailinglist File	
	# -----------------------------------------------------------------------------	
	foreach $line (@mailinglist) {
		
		local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
		
		# -----------------------------------------------------------------------------	
		# Found user: Fill format & checked Boards
		# -----------------------------------------------------------------------------
		if ($user eq $INFO{'username'}) {	
			$MailinglistFormat = $format;							
			@checkedBoards = split( /,/, $oldsubscribed);
		}
	}	

	# Read the Userdata
	&ReadUserData($FORM{'username'});		
		
	# -----------------------------------------------------------------------------	
	# Print on Profile [HEADER]
	# -----------------------------------------------------------------------------		
	$yymain .= qq~
     <tr>
	<td width="320"><font size=2><b>$notify_txt{'22'} </b></font><BR>
	<font size=1>$notify_txt{'23'}</font></td>
	<td><font size=2>
~;	

# Plain Text
if ($MailinglistFormat ne "HTML") {
$yymain .= qq~
		<input type="radio" name="MalinglistFormat" value="HTML"><font size="2">&nbsp;$notify_txt{'2'}</font>
		<input type="radio" name="MalinglistFormat" value="Plain Text" checked><font size="2">&nbsp;$notify_txt{'3'}</font>
~;
}
# HTML
else {
$yymain .= qq~
		<input type="radio" name="MalinglistFormat" value="HTML" checked><font size="2">&nbsp;$notify_txt{'2'}</font>
		<input type="radio" name="MalinglistFormat" value="Plain Text"><font size="2">&nbsp;$notify_txt{'3'}</font>
~;
}	

$yymain .= qq~ 
    </font></td>
      </tr><tr>
	<td width="320" valign="top"><font size=2><b>$notify_txt{'24'} </b></font><BR>
	<font size=1>$notify_txt{'25'}</font></td>
	<td valign="top"><font size=2>
~;	

	# -----------------------------------------------------------------------------	
	# Print on Profile [Checked Boards]
	# -----------------------------------------------------------------------------
	# Read all Categories
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	
	foreach $curcat (@categories) {

		chomp $curcat;
		fopen(FILE, "$boardsdir/$curcat.cat");
		
		# Read Categorie Name 
		$curcatname = <FILE>;
		chomp $curcatname;
		
		# Read Categorie Acces (which Member-groups)
		$curcataccess = <FILE>;
		chomp $curcataccess;
		
		# Rest are the Boards within this Categorie
		@catinfo = <FILE>;
		fclose(FILE);
		
		# Has user acces to this Categorie ??
		$useracces = 0;		

		# User is Administrator/(Global) Moderator
		if ($user_membergroup eq "Administrator" || exists $moderators{$INFO{'username'}} || $user_membergroup eq "Global Moderator") {
			$useracces = 1;
		}
		else {

			@membergroups = split( /,/, $curcataccess);

			# Everyone has acces to this Categorie or user is Administrator
			if ($curcataccess eq "") {
				$useracces = 1;
			}
			# Check acces
			else {
				# Read all Membergroups
				foreach $mgroup (@membergroups) {
			
					# Yep, user has acces !
					if ($mgroup eq $user_membergroup) {
						$useracces = 1;
						last;
					 }
				}
			}	
		}			

		# Read all Boards in this Categorie when user has acces
		if ($useracces == 1) {
		
			# Print Categorie
			$yymain .= qq~
			<table>			
			<tr>
				<td align="left"> 
					<font size="2"><b>$curcatname</b></font>
				</td>
			</tr>
~;
		
			# Read Boards in current Categorie
			foreach $curboard (@catinfo) {
				chomp $curboard;
			
				# Read the Board-Info
				fopen(FILE, "$boardsdir/$curboard.dat");
				@boardinfo = <FILE>;
				fclose(FILE);
				
				# This Board is on Mailinglist ?
				$checkboxChecked = "";
				foreach $checkedboard (@checkedBoards) {
					
					if ($checkedboard eq $curboard) {
						$checkboxChecked = "checked";
					}
				}

				# Get Boardname
				chomp $boardinfo[0];
				$boardname = $boardinfo[0];

							$yymain .= qq~
				<tr>
					<td align="left">
						<input type="checkbox" name="$curboard.check" value="1" $checkboxChecked>&nbsp;<font size="2">$boardname&nbsp;</font>
					</td>
				</tr>
~;
			# End foreach Board
			}
				
			$yymain .= qq~		
				</table>
~;

		# End if user has acces	
		}

	# End Each Categorie
	}	

	$yymain .= qq~
    </font></td>
      </tr>
~;

}

# =============================================================================
# ShowHTMLPrefs
# =============================================================================
sub ShowHTMLPrefs {

	$yymain .= qq~
    <tr>
	<td width="320"><font size=2><b>$notify_txt{'46'}</b></font><br>
	<font size=1>$notify_txt{'47'}</font></td>
	<td valign="top">
~;

	# Read Userdata
	&ReadUserData($INFO{'username'});

	# HTML
	if ($user_format eq "Plain") {
		$yymain .= qq~ 
			<input type="radio" name="user_format" value="Plain" checked><font size="2">&nbsp;$notify_txt{'3'}</font>
			<input type="radio" name="user_format" value="HTML"><font size="2">&nbsp;$notify_txt{'2'}</font>
			<input type="radio" name="user_format" value="HTML-Attach"><font size="2">&nbsp;$notify_txt{'45'}</font>
~;
	}
	# Normal HTML
	elsif ($user_format eq "HTML") {
		$yymain .= qq~ 
			<input type="radio" name="user_format" value="Plain"><font size="2">&nbsp;$notify_txt{'3'}</font>
			<input type="radio" name="user_format" value="HTML" checked><font size="2">&nbsp;$notify_txt{'2'}</font>
			<input type="radio" name="user_format" value="HTML-Attach"><font size="2">&nbsp;$notify_txt{'45'}</font>
~;
	}
	# HTML-Attached
	else {
		$yymain .= qq~ 
			<input type="radio" name="user_format" value="Plain"><font size="2">&nbsp;$notify_txt{'3'}</font>
			<input type="radio" name="user_format" value="HTML"><font size="2">&nbsp;$notify_txt{'2'}</font>
			<input type="radio" name="user_format" value="HTML-Attach" checked><font size="2">&nbsp;$notify_txt{'45'}</font>
~;
	}

	$yymain .= qq~ 
	</td>
    </tr><tr>
	<td width="320"><font size=2><b>$notify_txt{'39'}</b></font><br>
	<font size=1>$notify_txt{'17'}</font></td>
	<td valign="top">
~;

	if ($enable_includeimages) { $includeimageschecked = "checked" }
	if ($user_includeimg == 0) {
    	$yymain .= qq~		<input type="checkbox" name="user_includeimg" value="1">\n ~;
	}
	else {
    	$yymain .= qq~		<input type="checkbox" name="user_includeimg" value="1" checked>\n ~;
	}

	$yymain .= qq~ 
	</td>
    </tr>
~;

}

# =============================================================================
# Updatemailinglist
# =============================================================================
sub UpdateMailinglist {

	# Set variables
	$subscribed = "";
	
	# Read mailinglist File
	fopen(FILE, "$vardir/mailinglist.txt");
	@mailinglist = <FILE>;
	fclose (FILE);

	# Read all Categories
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	
	foreach $curcat (@categories) {

		chomp $curcat;

		fopen(FILE, "$boardsdir/$curcat.cat");

		# Read Categorie Name 
		$curcatname = <FILE>;
		chomp $curcatname;
		
		# Read Categorie Acces (which Member-groups)
		$curcataccess = <FILE>;
		chomp $curcataccess;
		
		# Rest are the Boards within this Categorie
		@catinfo = <FILE>;
		fclose(FILE);
		
		foreach $curboard (@catinfo) {
		
			chomp $curboard;

			# Board checked ?
			$checkbox = "$curboard.check";
			
			if ($FORM{$checkbox} == 1) {
				$subscribed .= $curboard . ",";
			}
		# End each Board	
		}
	# End each Categorie	
	}	
	
	# Update mailinglist File
	unlink("$vardir/mailinglist.txt");
	fopen(FILE, ">$vardir/mailinglist.txt");		
	$userfound = 0;	

	foreach $line (@mailinglist) {
		
		chomp($line);
		
		local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
		
		# Found user ?
		if ($user eq $FORM{'username'}) {
		
			$userfound = 1;
			
			# If no board checked: UN-subscribe !
			# Always update the email-address !!!
			if ($subscribed ne "") {
				print FILE "$user|$FORM{'email'}|$FORM{'MalinglistFormat'}|$subscribed\n";
			}
		}
		else {
			print FILE "$line\n";
		}
	}	
	
	# When user not found: Add !
	if ($userfound == 0 && $subscribed ne "") {
		print FILE "$FORM{'username'}|$FORM{'email'}|$FORM{'MalinglistFormat'}|$subscribed\n";
	}
	
	# Close file
	fclose (FILE);
}

# =============================================================================
# UpdateNotifiedBoards
# =============================================================================
sub UpdateNotifiedBoards {
	
	# Read the Userdata
	&ReadUserData($FORM{'username'});
	
	# Read all Categories
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	
	foreach $curcat (@categories) {

		chomp $curcat;

		fopen(FILE, "$boardsdir/$curcat.cat");

		# Read Categorie Name 
		$curcatname = <FILE>;
		chomp $curcatname;
		
		# Read Categorie Acces (which Member-groups)
		$curcataccess = <FILE>;
		chomp $curcataccess;
		
		# Rest are the Boards within this Categorie
		@catinfo = <FILE>;
		fclose(FILE);
		
		foreach $curboard (@catinfo) {
		
			chomp $curboard;

			# Board checked: Subscribe
			$checkbox = $curboard . "_notify.check";
			if ($FORM{$checkbox} == 1) {
			
				# Is there a board-notification file ?
				if (-e("$boardsdir/$curboard.mail")) {

					fopen(FILE, "$boardsdir/$curboard.mail") || return 0;
					@boardmails = <FILE>;
					fclose(FILE);

					print FILE "$user_email|\n";
		
					foreach $record (@boardmails) {
	
						chomp($record);
						($email, $format) = split(/\|/, $record);
						chomp($email);
						if($user_email ne $email) { print FILE "$record\n"; }
					}
				}	
				# Write a new board-notification file			
				else {

					fopen(FILE, ">$boardsdir/$curboard.mail") || return 0;
					print FILE "$user_email|\n";
					fclose(FILE);
				}
			# End Board checked: Subscribe				
			}
				
			# Board not checked: Unsubscribe
			else {
			
				# If there is a board-notification file
				if (-e("$boardsdir/$curboard.mail")) {	

					fopen(FILE, "$boardsdir/$curboard.mail") || return 0;
					@boardmails = <FILE>;
					fclose(FILE);
																
					fopen(FILE, ">$boardsdir/$curboard.mail") || return 0;
					foreach $record (@boardmails) {
		
						chomp($record);
						($email, $format) = split(/\|/, $record);
						chomp($email);
						if($user_email ne $email) { print FILE "$record\n"; }
					}
				}
				
			# End if Board checked	
			}		
	
		# End each Board	
		}
	# End each Categorie	
	}	
}

# =============================================================================
# Viewmailinglist
# =============================================================================
sub ViewMailinglist {

	# Only Admin !
	&is_admin;

	# Read mailinglist File
	fopen(FILE, "$vardir/mailinglist.txt");
	@mailinglist = <FILE>;
	fclose (FILE);			
	
	# Initialise Variables
	$MembersPerPage = 10;	
	$mailinglist_entry = 0;	
	$numbershown = 0;	
	
	# Determine Total Members to show
	$membercount = 0;
	foreach $line (@mailinglist) {
		$membercount = $membercount + 1;
	}	
	
	# Determine Start-record
	if ($INFO{'start'} eq "") { $start = 0; }
	else { $start = "$FORM{'start'}"; }
	
	$numberbegin = ($start + 1);
	$numberend = ($start + $MembersPerPage);
	if($numberend > $membercount) {
		$numberend = $membercount;
	}
	
	# -----------------------------------------------------------------------------
	# Print Page
	# -----------------------------------------------------------------------------	
	$yymain .= qq~
	<form action="$cgi;action=deletefrommailinglist" method="POST">
	<table border=0 cellspacing=0 cellpadding="3" align="center" width="85%">
	<tr>
		<td bgcolor="$color{'titlebg'}" align="center" class="titlebg">
			<font size="2" class="text1" color="$color{'titletext'}"><b>$notify_txt{'26'} $numberbegin $txt{'311'} $numberend ($txt{'309'} $membercount)</b></font>
		</td>
	</tr>
	</table>
	
	<table border=0 width=85% align=center cellspacing="1" bgcolor="$color{'bordercolor'}" class="bordercolor">
	<tr>
		<td class="catbg" bgcolor="$color{'catbg'}" valign="top"><b><font size=2>$txt{'35'}</font></b></td>
		<td class="catbg" bgcolor="$color{'catbg'}" valign="top"><b><font size=2>$notify_txt{'27'}</center></font></b></td>
		<td class="catbg" bgcolor="$color{'catbg'}" valign="top"><b><font size=2><center>$notify_txt{'28'}</center></font></b></td>		
		<td class="catbg" bgcolor="$color{'catbg'}" valign="top"><b><font size=2>$notify_txt{'29'}</center></font></b></td>
		<td class="catbg" bgcolor="$color{'catbg'}" valign="top"><b><font size=2><center>$notify_txt{'30'}</center></font></b></td>		
	</tr>
~;
	# -----------------------------------------------------------------------------
	# Read the mailinglist
	# -----------------------------------------------------------------------------	
	FOREACH: foreach $line (@mailinglist) {
	
		# Quit when max Members per page
		if ($numbershown == $MembersPerPage) { last; }

		# Start with right entry for this page !!
		$mailinglist_entry = $mailinglist_entry + 1;
		if ($mailinglist_entry < $numberbegin) { next FOREACH; }
		
		# Count number of members on this page
		$numbershown = $numbershown + 1;
		
		# OK: Print Member data		
		local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
		@checkedBoards = split( /,/, $oldsubscribed);	
		$checkboxDelete = $user . "Delete";	
		
		# Read the Userdata
		&ReadUserData($user);
	
		# -----------------------------------------------------------------------------
		# Print TABLE
		# -----------------------------------------------------------------------------
		$yymain .= qq~
	<tr>
		<td class="windowbg" bgcolor="$color{'windowbg'}" valign="top"><font size=2><a href="$cgi;action=viewprofile;username=$user">$user</a></font></td>
		<td class="windowbg" bgcolor="$color{'windowbg'}" valign="top"><font size=2>$email</font></td>
		<td class="windowbg2" bgcolor="$color{'windowbg2'}" align="center" valign="top"><font size=2>$format</font></td>
		<td class="windowbg2" bgcolor="$color{'windowbg2'}" valign="top">
			<table>
			<tr>
				<td>	
~;
	
	# -----------------------------------------------------------------------------
	# Print all members on mailinglist
	# -----------------------------------------------------------------------------
	# Read all Categories
	fopen(FILE, "$vardir/cat.txt");
	@categories = <FILE>;
	fclose(FILE);
	
	foreach $curcat (@categories) {

		# Initialise Categorie printed yet ?
		$catprinted = 0;	
	
		chomp $curcat;
		fopen(FILE, "$boardsdir/$curcat.cat");
		
		# Read Categorie Name 
		$curcatname = <FILE>;
		chomp $curcatname;
		
		# Read Categorie Acces (which Member-groups)
		$curcataccess = <FILE>;
		chomp $curcataccess;
		
		# Rest are the Boards within this Categorie
		@catinfo = <FILE>;
		fclose(FILE);
		
		# Has user acces to this Categorie ??
		$useracces = 0;
		@membergroups = split( /,/, $curcataccess);
		
		# Everyone has acces to this Categorie or user is Administrator
		if ($curcataccess eq "") {
			$useracces = 1;
		}
		# User is Administrator/(Global) Moderator
		if ($user_membergroup eq 'Administrator' || exists $moderators{'$user'} || $user_membergroup eq "Global Moderator") {
			$useracces = 1;
		}		
		# Check acces
		else {
		
			# Read all Membergroups
			foreach $mgroup (@membergroups) {

				# Yep, user has acces !
				if ($mgroup eq $user_membergroup) {
					$useracces = 1;
					last;
				 }
			}
		}			
		
		# Read all Boards in this Categorie when user has acces
		if ($useracces == 1) {

			# Read Boards in current Categorie
			foreach $curboard (@catinfo) {
				chomp $curboard;
			
				# Read the Board-Info
				fopen(FILE, "$boardsdir/$curboard.dat");
				@boardinfo = <FILE>;
				fclose(FILE);

				# Get Boardname
				chomp $boardinfo[0];
				$boardname = $boardinfo[0];
				
				# This Board is on mailinglist ?
				foreach $checkedboard (@checkedBoards) {
					
					if ($checkedboard eq $curboard) {
					
						# Categorie printed yet ?
						if ($catprinted == 0) {	
								
							# Print Categorie description
							$yymain .= qq~ <font size=\"1\"><b>$curcatname</b></font><br> ~;
							$catprinted = 1;
						}	
						$yymain .= qq~ <font size=\"2\">&nbsp;&nbsp;$boardname</font><br> ~;
					}
				# End This Board is on mailinglist
				}	
			# End Read Boards in current Categorie				
			}
		# End useracces	
		}
	# End Read all Categories	
	}		

	$yymain .= qq~	
				</td>
			</tr>
		</table>						
		<td class="windowbg" bgcolor="$color{'windowbg'}" align="center" valign="top"><input type="checkbox" name="$checkboxDelete" value="$notify_txt{'28'}"></td>
	</tr>
~;
	
	# End Userdata in mailinglist
	}

$yymain .= qq~
	</table>	

	<table border="0" width="85%" bgcolor="$color{'titlebg'}" align="center" class="titlebg" cellspacing="0" cellpadding="1">
	<tr>
		<td><font size="2"><b>$txt{'139'}:</b>
~;
	$counter = 0;
	while(($counter * $MembersPerPage) < $membercount) {
		$viewcounter = $counter+1;
		$pagestart = ($counter * $MembersPerPage);
		if($start == $pagestart) {
			$yymain .= qq~ $viewcounter ~;
		}
		else {
			$yymain .= qq~ <a href="$cgi;action=viewmailinglist;start=$pagestart">$viewcounter</a> ~;
		}
		++$counter;
	}
	$yymain .= qq~ 
		</td>
	    <td align="right"><input type=submit value="$txt{'608'}"></td>
	</tr>
	</table>
	</form>
~;

	$yytitle = "$notify_txt{'20'}";
	&template;
	exit;	
}

# =============================================================================
# DeleteFrommailinglist
# =============================================================================
sub DeleteFromMailinglist {

	# Read mailinglist File
	fopen(FILE, "$vardir/mailinglist.txt");
	@mailinglist = <FILE>;
	fclose (FILE);
	
	# Open file again to update !
	unlink("$vardir/mailinglist.txt");
	fopen(FILE, ">$vardir/mailinglist.txt");
	
	# -----------------------------------------------------------------------------
	# Read the mailinglist File	
	# -----------------------------------------------------------------------------	
	foreach $line (@mailinglist) {
		
		chomp($line);
		local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
		
		# Write Member when not deleted
		$checkboxDelete = $user . "Delete";
		if (! exists $FORM{"$checkboxDelete"}) {
			print FILE "$line\n";
		}
	}	
	
	# Close file
	fclose (FILE);
	
	# Back to View Members Page
	$yySetLocation = qq~$scripturl?action=viewmailinglist~;
	&redirectexit;
}

# =============================================================================
# Sendmailinglist
# =============================================================================
sub SendMailinglist {
	
	# Only Admin !
	&is_admin;
	
	# Open default mailinglist Text
	fopen(FILE, "$vardir/mailtext.txt");
	@mailtext = <FILE>;
	fclose(FILE);

	$yymain .= qq~
<form action="$cgi;action=sendmailinglist2" method="POST">
<table border="0" width="70%" cellspacing="1" cellpadding="3" bgcolor="$color{'bordercolor'}" class="bordercolor" align="center">
	<tr>
		<td class="titlebg" bgcolor="$color{'titlebg'}">
			<img src="$imagesdir/xx.gif" alt="">
			<font size="2" class="text1" color="$color{'titletext'}"><b>$notify_txt{'19'}</b></font>
		</td>
	</tr>
	<tr>
		<td class="windowbg" bgcolor="$color{'windowbg'}">
			<br>	
			<font size="1">$notify_txt{'31'}</font>
			<br>
			<br>
		</td>
	</tr>
	<tr>
	    <td class="windowbg2" bgcolor="$color{'windowbg2'}">
	    	<font size="2">
			&nbsp;<b>$notify_txt{'35'}</b> <input type="text" name="mailsubject" value="$mailtext[1]" size="50" maxlength="50">
			</font>	
		</td>
	</tr>				
	<tr>
	    <td class="windowbg2" bgcolor="$color{'windowbg2'}" align="center">
			<br>
	    	<font size="2">
			<textarea cols="70" rows="8" name="mailtext">
~;
	
	# Print all lines	
	$counter = 0;		
	foreach $line (@mailtext) {
	
		# Skip first two lines (Date sent last mailinglist/Subject)
		++$counter;		
		if ($counter < 3) { next; }
		if ($line =~ m~\A\s*\Z~) { next; }
		$yymain .= qq~$line\n~;
	}
	
	$yymain .= qq~
</textarea>
			<br>
			<input type="submit" value="$notify_txt{'32'}"></font>
			<br>
		</td>
	</tr>
</table>
</form>
~;

	$yytitle = "$notify_txt{'21'}";
	&template;
	exit;
}

# =============================================================================
# Sendmailinglist2
# =============================================================================
sub SendMailinglist2 {
		
	# Store editted default mailinglist Text
	unlink("$vardir/mailtext.txt");
	fopen(FILE, ">$vardir/mailtext.txt");
	print FILE "$yday|$mon_num|$yday|$date\n";

	# When Send Mailinglist
	if ($action eq 'sendmailinglist2') {
		print FILE "$FORM{'mailsubject'}\n";	
		print FILE "$FORM{'mailtext'}";
	}	
	# When Autosend and subject empty
	elsif (@mailtext[1] eq "") {
		print FILE "$notify_txt{'58'}\n";	
		print FILE "@mailtext[2]";	
	}
	# When Autosend and subject not empty
	else {
		print FILE "@mailtext[1]\n";	
		print FILE "@mailtext[2]";	
	}

	fclose(FILE);
	chmod 0644, "$vardir/mailtext.txt";

	# Read the New Posts File
	fopen(FILE, "$vardir/newposts.txt");
	@newposts = <FILE>;
	fclose (FILE);
	
	# Initialise NoPosts	
	$noposts = 0;
	
	# Get style- & body-tag from template.html		
	&ReadTemplate;
		
	# -----------------------------------------------------------------------------
	# Fill Board Arrays with new posts-data
	# -----------------------------------------------------------------------------
	if (@newposts) {
		
		# Set NoPosts	
		$noposts = 1;

		foreach $newpost (@newposts) {
			local($board, $newpostid, $postdate) = split(/\|/, $newpost);
			
			chomp($postdate);
			
			# Write Board-Thread Info to correct Array
			$array = $board . "_Array";
	
			# Get Board-description
			fopen(FILE, "$boardsdir/$board.dat");
			@boards = <FILE>;
			fclose (FILE);
			$boarddescr{"$board"} = $boards[0];
			$$array{"$newpostid"} = $postdate;
			
			if (! $newpostboard_Array{"$board"}) { $newpostboard_Array{"$board"} = $array; }
			
			# Read Thread data
			fopen(FILE, "$datadir/$newpostid.txt");
			@threads = <FILE>;
			fclose (FILE);		
		
			# Write Thread-Post Info to correct Array
			$array = $newpostid . "_Array";
		
			# -----------------------------------------------------------------------------
			# Read all posts
			# -----------------------------------------------------------------------------		
			$postcount = 0;
			$newpostfound = 0;		
			foreach $post (@threads) {
	
				local($subject,$name,$email,$date,$username,$icon,$dummy,$dummy,$message,$dummy) = split(/\|/, $post);	
				
				# Always store initial post !
				if ($postcount == 0) {
					$$array{"$postcount"} = "$subject|$name|$email|$date|$username|$icon|$message\n";
	
					# Check if initial is ALSO first
					if ($date eq $postdate) { $newpostfound = 1; }
				}
				
				# THEN start with new post and read further !!
				elsif ($date eq $postdate || $newpostfound == 1) {
					$$array{"$postcount"} = "$subject|$name|$email|$date|$username|$icon|$message\n";						
					$newpostfound = 1;
				}	 
				++$postcount;
				
			# End for all posts	
			}
		# End foreach new post	
		}
	# End if @newposts filled	
	}
	# -----------------------------------------------------------------------------
	# Read mailinglist File
	# -----------------------------------------------------------------------------
	fopen(FILE, "$vardir/mailinglist.txt");
	@mailinglist = <FILE>;
	fclose (FILE);		

	# Send email to each member on mailinglist	
	foreach $line (@mailinglist) {
		
		local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
		@checkedBoards = split( /,/, $oldsubscribed);
					
		# Read all required Member-data	
		&ReadUserData($user);
							
		# Fill Mailinglist-format & email				
		$user_format = $format;
		$user_email = $email;
		
		# First replace [member] with username
		$mailsubject = $FORM{'mailsubject'};	
		$mailsubject =~ s/\[member\]/$user_name/gi;								
		$mailtext = $FORM{'mailtext'};
		$mailtext =~ s/\[member\]/$user_name/gi;
		
		# Second replace [date] with today's date
		&get_date;
		&timeformat($date,1);
		$new_date = $newformat;
		$mailsubject =~ s/\[date\]/$new_date/gi;
		$mailtext =~ s/\[date\]/$new_date/gi;											
		
		# -----------------------------------------------------------------------------		
		# Compose the message [HEADER]
		# -----------------------------------------------------------------------------		
		# --- HTML-message ---
		$HTMLmailtext = $mailtext;
		$HTMLmailtext =~ s/\n/<br>/gi;
			
		$HTMLvariable = << "EOT";

<html>
<head>
<title></title>
EOT
			
		# Print Style
		foreach $line (@style) {
			$HTMLvariable .= $line;
		}
		
		$HTMLvariable .= << "EOT";
</head>
$body
				
<table border="0">
<tr>
	<td>
		<font size="2">$HTMLmailtext</font>
	</td>	
</tr>		
</table>		
<p>
<table width="100%" border="0">
EOT
	
		# -----------------------------------------------------------------------------						
		# HEADER - Fill message variables
		# -----------------------------------------------------------------------------
		$theHTMLmessage = $HTMLvariable;
		$theHTMLmessage_include = $HTMLvariable;

		# --- Plain message ---
		# First replace the <br>'s with \n's	
		$PLAINmailtext = $mailtext;					
		$PLAINmailtext =~ s/<br>/\n/gi;
	
		$thePLAINmessage = << "EOT";
$PLAINmailtext
EOT
	
		# -----------------------------------------------------------------------------						
		# No new Posts
		# -----------------------------------------------------------------------------				
		if ($noposts == 0) {
			
			# --- HTML message ---
			$HTMLvariable = << "EOT";
<tr>
	<td><font size="2">$notify_txt{'34'}</font></td>
</tr>
EOT
	
			# -----------------------------------------------------------------------------						
			# NO POSTS - Fill message variables
			# -----------------------------------------------------------------------------
			$theHTMLmessage .= $HTMLvariable;
			$theHTMLmessage_include .= $HTMLvariable;

			# --- Plain message ---
			$thePLAINmessage .= << "EOT";			
$notify_txt{'34'}
EOT

		}
		# -----------------------------------------------------------------------------		
		# Read all subscribed boards for this user
		# -----------------------------------------------------------------------------
		else {
		
			foreach $board (@checkedBoards) {
			
				# Send the new posts for this board (when it has new posts)
				chomp($board);
				if ($board ne "" && $newpostboard_Array{"$board"}) {
	
					# Compose the message [BOARDNAME]
					# --- HTML message ---
					chomp($boarddescr{"$board"});
					$HTMLvariable = << "EOT";			
<tr>
	<td align="left" valign="middle" colspan="2">
		<hr width="100%" size="2" color="$color{'bordercolor'}">
		<font face="Verdana" size="2"><b>$boarddescr{"$board"}</b></font><br>
		<hr width="100%" size="2" color="$color{'bordercolor'}">
	</td>
</tr>
EOT
					
					# -----------------------------------------------------------------------------						
					# BOARD - Fill message variables
					# -----------------------------------------------------------------------------
					$theHTMLmessage .= $HTMLvariable;
					$theHTMLmessage_include .= $HTMLvariable;

					# --- Plain message ---
					$newboard = 1;
					$new_board = $boarddescr{"$board"};
					$thePLAINmessage .= << "EOT";	
		
=============================================================================

$new_board

=============================================================================
EOT

					# Read the new posts for this Board
					$array = $board . "_Array";
	
					foreach $newpostid (keys %$array) {
					
						# Read all threads
						$array = $newpostid . "_Array";

						foreach $newpost (sort { $$array{$a} <=> $$array{$b} || ($a <=> $b)} keys %$array) {	
							# Get the needed fieds
							local($subject,$name,$email,$date,$username,$icon,$message,$dummy) = split(/\|/, $$array{"$newpost"});	 
							
							# -----------------------------------------------------------------------------		
							# Compose the message [POSTS]
							# -----------------------------------------------------------------------------				
							# First Post
							if ($newpost == 0) {
							
								# --- HTML message ---		
								$HTMLvariable = << "EOT";
<tr>
	<td align="left" valign="middle" colspan="2">
		<hr width="100%" size="2" color="$color{'windowbg3'}" class="windowbg3">	
	</td>
</tr>		
<tr>
	<td align="left" valign="top">
EOT
	
								# -----------------------------------------------------------------------------						
								# FIRST POST - Fill message variables
								# -----------------------------------------------------------------------------
								# Images not included								
								$theHTMLmessage .= $HTMLvariable;
								$theHTMLmessage .= << "EOT";
	<img src="$imagesdir/$icon.gif">
EOT
								# Images included
								$theHTMLmessage_include .= $HTMLvariable;
								$theHTMLmessage_include .= << "EOT";	
	<img src="$imagesurl/$icon.gif">
EOT

									
								$HTMLvariable = << "EOT";
	</td>
	<td align="left" valign="top">
		<font size="2"><b>$subject</b></font> &nbsp;<br>
		<font size="1">&#171; <b>$txt{'318'} <a href="mailto:$email">$name</a> $notify_txt{'9'} </b> $date &#187;</font>
	</td>
</tr>
<tr>
	<td align="left" valign="top" colspan="2">
		<hr width="100%" size="1" color="$color{'windowbg3'}" class="windowbg3">
		<font size="2">
EOT
	
								# -----------------------------------------------------------------------------						
								# MESSAGE - Fill message variables
								# -----------------------------------------------------------------------------
								# Images not included
								$theHTMLmessage .= $HTMLvariable;
								$save_message = $message;
								if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; } 
								$theHTMLmessage .= $message;

								# Images included
								$theHTMLmessage_include .= $HTMLvariable;
								$message = $save_message;
								if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC("IncludeImage"); }
								$theHTMLmessage_include .= $message;								

								$HTMLvariable = << "EOT";
		</font>
		<p>
	</td>
</tr>
EOT

								# Fill message variables
								$theHTMLmessage .= $HTMLvariable;
								$theHTMLmessage_include .= $HTMLvariable;

								# --- Plain message ---													
								# New Board ?
								if ($newboard == 1) {
									$newboard = 0;
									
									# Replace the <br>'s with \n's
									$plainmessage = $save_message;
									$plainmessage =~ s/<br>/\n/gi;
									&FromHTML($plainmessage);
											
									$thePLAINmessage .= << "EOT";

<< $subject >>
$txt{'318'} $name $notify_txt{'9'} $date

$plainmessage
EOT
								}
								# Not a new Board ?								
								else {
	
								$thePLAINmessage .= << "EOT";
							
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

<< $subject >>
$txt{'318'} $name $notify_txt{'9'} $date

$plainmessage
EOT
								# End new board ?
								}
							}								
							# All other Posts
							else {
	
								# --- HTML message ---			
								$HTMLvariable = << "EOT";
<tr>
	<td colspan="2">
		<table width="100%" border="0">
		<tr>
			<td width="25"></td>
			<td align="left" valign="top" colspan="2">
				<hr width="100%" size="2" color="$color{'windowbg3'}" class="windowbg3">	
			</td>
		</tr>
		<tr>
			<td width="25"></td>		
			<td align="left" valign="top">
EOT

								# -----------------------------------------------------------------------------						
								# OTHER POSTS - Fill message variables
								# -----------------------------------------------------------------------------
								# Images included								
								$theHTMLmessage .= $HTMLvariable;
								$theHTMLmessage .= << "EOT";
	<img src="$imagesdir/$icon.gif">								
EOT
								# Images not included
								$theHTMLmessage_include .= $HTMLvariable;
								$theHTMLmessage_include .= << "EOT";	
	<img src="$imagesurl/$icon.gif">
EOT
								$HTMLvariable = << "EOT";			
			</td>
			<td align="left" valign="top">				
				<font size="1">&#171; <b>$notify_txt{'8'} <a href="mailto:$email">$name</a> $notify_txt{'9'} </b> $date &#187;</font>
			</td>
		</tr>
		<tr>
			<td width="25"></td>		
			<td align="left" valign="top" colspan="2">
				<hr width="100%" size="1" color="$color{'windowbg3'}" class="windowbg3">
				<font size="2">
EOT
	
								# -----------------------------------------------------------------------------						
								# MESSAGE - Fill message variables
								# -----------------------------------------------------------------------------
								# Images not included
								$theHTMLmessage .= $HTMLvariable;
								$save_message = $message;
								if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC; }
								$theHTMLmessage .= $message;
					
								# Images included
								$theHTMLmessage_include .= $HTMLvariable;
								$message = $save_message;
								if($enable_ubbc) { if(!$yyYaBBCloaded) { require "$sourcedir/YaBBC.pl"; } &DoUBBC("IncludeImage"); }
								$theHTMLmessage_include .= $message;								
								
								$HTMLvariable = << "EOT";			
				</font>
				<p>
			</td>
		</tr>	
		</table>
	</td>
</tr>			
EOT

								# Fill message variables
								$theHTMLmessage .= $HTMLvariable;
								$theHTMLmessage_include .= $HTMLvariable;

								# --- Plain message ---		
								# Replace the <br>'s with \n's
								$plainmessage = $save_message;
								$plainmessage =~ s/<br>/\n/gi;
								&FromHTML($plainmessage);							

								$thePLAINmessage .= << "EOT";

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
>> $notify_txt{'8'} $name $notify_txt{'9'} $date

$plainmessage
EOT
							# End first/all posts
							}
						# End read all threads
						}	
					# End Read the new posts		
					}
				
				# End Send the new posts	
				}	
			# End Read all subscribed boards	
			}
		# End if No Posts	
		}

		# -----------------------------------------------------------------------------		
		# Compose the message [FOOTER]
		# -----------------------------------------------------------------------------				
		# --- HTML message ---
		$HTMLvariable = << "EOT";
</table>
</font>
				
</body>
</html>
EOT

		# Fill message variables
		$theHTMLmessage .= $HTMLvariable;
		$theHTMLmessage_include .= $HTMLvariable;	
		
		# Write message.html
		fopen(FILE, ">$vardir/message.html");
		print FILE "$theHTMLmessage";
		fclose(FILE);

		# -----------------------------------------------------------------------------								
		# Send the email
		# -----------------------------------------------------------------------------		
		# Fill format, image-include and Subject 		
		$subject = $mailsubject;								
		&SendMail($user_email);
		
	# End Send email to each member on mailinglist
	}		
	
	# Delete New Posts File
	unlink("$vardir/newposts.txt");

	# Back to Admin Page when not autosend !!
	if ($autosend_on ne "Y") {
		$yySetLocation = qq~$scripturl?action=admin~;
		&redirectexit;
	}
}

# =============================================================================
# ReadTemplate
# =============================================================================
sub ReadTemplate {

	# Get style- & body-tag from template.html
	@style = ();
	$strstyle = 0;
	$endstyle = 0;
	
	fopen(FILE, "$boarddir/template.html");
	@template = <FILE>;
	fclose (FILE);
	
	foreach $line (@template) {
	
		$newline = $line;
		chomp($newline);
		
		# -----------------------------------------------------------------------------
		# Style-tag
		# -----------------------------------------------------------------------------		
		# Start of style-tag
		if ($newline eq "<style type=\"text/css\">") {
			$strstyle = 1;
		}
		
		# End of style-tag
		if ($newline eq "</style>") {
			$endstyle = 1;
			push (@style, $line);			
		}	
		
		# Save style-tag
		if ($strstyle == 1 && $endstyle == 0) {
			push (@style, $line);
		}	
	
		# -----------------------------------------------------------------------------
		# Body-tag
		# -----------------------------------------------------------------------------		
		if (substr($line, 0, 5) eq "<body") {
			$body = $line;
		}
	}
}

# =============================================================================
# RemoveThread_Mailinglist
# =============================================================================
sub RemoveThread_Mailinglist {

	my $Mailinglist_Thread = $_[0];
	
	# Delete Thread from Mailinglist
	if ($enable_mailinglist == 1) {
	
		# Read New Posts File
		fopen(FILE, "$vardir/newposts.txt");
		@newposts = <FILE>;
		fclose (FILE);
	
		# Delete/Open file again to update !
		unlink("$vardir/newposts.txt");
		fopen(FILE, ">$vardir/newposts.txt");
	
		# -----------------------------------------------------------------------------
		# Read the New Posts File
		# -----------------------------------------------------------------------------
		foreach $newpost (@newposts) {
	
			chomp($newpost);
			local($board, $newpostid, $postdate) = split(/\|/, $newpost);
	
			# Write Thread when not deleted
			if ($newpostid ne $Mailinglist_Thread) {
				print FILE "$newpost\n";
			}
		}
		# Close file
		fclose (FILE);
	}
}

# =============================================================================
# RemoveBoard_Mailinglist
# =============================================================================
sub RemoveBoard_Mailinglist {

	my $Mailinglist_Board = $_[0];
	
	unlink("$boardsdir/$Mailinglist_Board.mail");

	# Delete Board from Mailinglist
	if ($enable_mailinglist == 1) {

		# Read Mailinglist File
		fopen(FILE, "$vardir/mailinglist.txt");
		@mailinglist = <FILE>;
		fclose (FILE);

		# Open file again to update !
		fopen(FILE, ">$vardir/mailinglist.txt");

		# -----------------------------------------------------------------------------
		# Read the mailinglist File
		# -----------------------------------------------------------------------------
		foreach $line (@mailinglist) {

			chomp($line);
			local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);
			@checkedBoards = split( /,/, $oldsubscribed);
			$newsubscribed = "";

			# Write Member when not deleted
			foreach $board (@checkedBoards) {

				chomp($board);
				if ($board ne $Mailinglist_Board) {
					$newsubscribed .= $board . ",";
				}
			}

			# If no board checked: UN-subscribe !
			if ($newsubscribed ne "") {
				print FILE "$user|$email|$format|$newsubscribed\n";
			}
		}

		# Close file
		fclose (FILE);
	}
}

# =============================================================================
# RemoveMember_Mailinglist
# =============================================================================
sub RemoveMember_Mailinglist {

	my $Mailinglist_Member = $_[0];

	unlink("$memberdir/$Mailinglist_Member.da2");

	# Delete Member from Mailinglist
	if ($enable_mailinglist == 1) {

		# Read Mailinglist File
		fopen(FILE, "$vardir/mailinglist.txt");
		@mailinglist = <FILE>;
		fclose (FILE);

		# Open file again to update !
		fopen(FILE, ">$vardir/mailinglist.txt");

		# -----------------------------------------------------------------------------
		# Read the mailinglist File
		# -----------------------------------------------------------------------------
		foreach $line (@mailinglist) {

			chomp($line);
			local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);

			# Write Member when not deleted
			if ($user ne $Mailinglist_Member) {
				print FILE "$line\n";
			}
		}
		# Close file
		fclose (FILE);
	}
}

# =============================================================================
# Autosend Mailinglist/Email Reminder
# =============================================================================
sub Autosend {

	# Get date
	&get_date;
	
	# Open default Mailinglist Text
	fopen(FILE, "$vardir/mailtext.txt");
	@mailtext = <FILE>;
	fclose(FILE);

	# Get date
	($last_reminder, $ml_month, $ml_yearday, $ml_date) = split(/\|/, @mailtext[0]);
	
	chomp($last_reminder);
	chomp($ml_month);
	chomp($ml_yearday);
	chomp($ml_date);
				
	# Check Frequency
	# Daily (and not already send today)
	if ($autosend_frequency eq "Daily" && $ml_yearday < $yday && $last_reminder != $yday) {
	
		# Mailinglist
		if ($autosend eq "Mailinglist") {
				
			# Set Autosend 'on'
			$autosend_on = "Y";
			
			# Send Mailinglist
			&SendMailinglist2;
				
			# Reset Autosend
			$autosend_on = "N";
		}
		# Email Reminder
		else {
			&SendReminder;
		}
	}
	# Weekly (and not already send today)
	elsif ($autosend_frequency eq "Weekly" && ($ml_yearday + 7) <= $yday && $last_reminder != $yday) {
	
		# Mailinglist
		if ($autosend eq "Mailinglist") {
			
			# Set Autosend 'on'
			$autosend_on = "Y";
			
			# Send Mailinglist
			&SendMailinglist2;
			
			# Reset Autosend
			$autosend_on = "N";
		}
		# Email Reminder
		else {
			&SendReminder;
		}
	}
	# Monthly (and not already send today)
	elsif ($autosend_frequency eq "Monthly" && $ml_month != $mon_num && $last_reminder != $yday) {
	
		# Mailinglist
		if ($autosend eq "Mailinglist") {
			
			# Set Autosend 'on'
			$autosend_on = "Y";
			
			# Send Mailinglist
			&SendMailinglist2;
			
			# Reset Autosend
			$autosend_on = "N";
		}
		# Email Reminder
		else {
			&SendReminder;
		}
	}
}

# =============================================================================
# Autosend Mailinglist/Email Reminder
# =============================================================================
sub SendReminder {

	# Store unchanged mailinglist Text
	$old_subject = $mailtext[1];
	chomp($old_subject);
	$old_message = "";
			
	# Print all lines	
	$counter = 0;		
	foreach $line (@mailtext) {
	
		# Skip first two lines (Date sent last mailinglist/Subject)
		++$counter;		
		if ($counter < 3) { next; }
		if ($line =~ m~\A\s*\Z~) { next; }
		$old_message .= qq~$line\n~;
	}
		
	unlink("$vardir/mailtext.txt");
	fopen(FILE, ">$vardir/mailtext.txt");
	print FILE "$yday|$ml_month|$ml_yearday|$ml_date\n";

	# When Autosend and subject empty
	if ($old_subject eq "") {
		print FILE "$notify_txt{'58'}\n";	
		print FILE "$old_message";	
	}
	# When Autosend and subject not empty
	else {
		print FILE "$old_subject\n";	
		print FILE "$old_message";	
	}

	fclose(FILE);
	chmod 0644, "$vardir/mailtext.txt";
	
	# Send Email Reminder
	$user_format = "Plain";
	$subject = $notify_txt{'59'};
	$thePLAINmessage = $notify_txt{'60'}; 
	&SendMail($email_reminder_address);
}

# =============================================================================
# Show all Guest Notifications
# =============================================================================
sub ShowGuestNotification {

	# Initialize
	$found_members = "";
	%guest_Array = ();
	$counter = 0;

	# Read all Member-email-addresses
	fopen(FILE, "$memberdir/memberlist.txt");
	@memberlist = <FILE>;
	fclose(FILE);

	foreach $member (@memberlist) {
		chomp($member);
		if( fopen(FILE2, "$memberdir/$member.dat") ) {
			@memberinfo = <FILE2>;
			$found_members .= " @memberinfo[2]";
			fclose(FILE2);
		}
	}

	# Read all .mail-Files and search for username
	opendir (DIRECTORY,"$datadir");
	@dirdata = readdir(DIRECTORY);
	closedir (DIRECTORY);
	@datdata = grep(/mail/,@dirdata);

	foreach $filename (@datdata) {
		fopen(FILE, "$datadir/$filename");
		@entries = <FILE>;
		fclose(FILE);

	    foreach $record (@entries) {

	       	chomp($record);
	       	($email, $user_format) = split(/\|/, $record);

	       	chomp($email);
	       	chomp($user_format);

	       	# Only Guests !
			# So check if email belongs to member...
	       	if (index($found_members, $email) == -1) {
				
				# Save Guest-email
				$guest_Array{"$counter"} = $email;
				
				# Push text from Language-file
				if ($user_format eq "HTML") { push(@found_format,$notify_txt{'2'}); }
				elsif ($user_format eq "HTML-Attach") { push(@found_format,$notify_txt{'45'}); }
				else { push(@found_format,$notify_txt{'3'}); }
			   
				($mnum, $dummy) = split(/\./,$filename);
				fopen(FILE, "$datadir/$mnum.txt");
				@messages = <FILE>;
				fclose(FILE);
				($msub, $mname, $memail, $mdate, $musername, $micon, $mattach, $mip,  $mmessage) = split(/\|/,$messages[0]);
				push(@found_number,$mnum);
				push(@found_subject,$msub);
				push(@found_date,$mdate);
				push(@found_username,$musername);
				push(@found_name,$mname);
				$counter++;
			}
		}
	}

	# Display all Entries
	$yymain .= qq~
<table border=0 width=100% cellspacing=1 cellpadding=6 bgcolor="$color{'bordercolor'}" class="bordercolor">
 <tr>
  <td bgcolor="$color{'titlebg'}">
   <font size=2 color="$color{'titletext'}"><b>$notify_txt{'62'}</b></font>
  </td>
 </tr><tr>
  <td bgcolor="$color{'windowbg'}">
   <font size=2>
    <br>
~;
	# -----------------------------------------------------------------------------
	# Show Notified Threads
	# -----------------------------------------------------------------------------
	# No Threads selected ?
	if (@found_number==0) {
		$yymain .= qq~ $txt{'414'}<br><br>&nbsp; ~;
	} else {
		foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$found_subject[$counter] =~ s~\Q$tmpa\E~$tmpb~gi;
		}

		# Show form for every Guest
		$saveguest = "";
		
		$yymain .= qq~ <font size=2>$notify_txt{'44'}</font><br>\n ~;

		#t %guest_Array = Field1,occurence1;Field2,ocuurence2; ...
		#t Will be sorted on occurence (alphanumeric, so use cmp) 
		foreach $Arraynumber (sort { $guest_Array{$a} cmp $guest_Array{$b} || ($a cmp $b)} keys %guest_Array) {
			
			# Get Guest-email
			$guest_email = $guest_Array{"$Arraynumber"};
			
			# Header/Footer (once per Guest)
			if ($guest_email ne $saveguest) {
	
				# Footer
				if ($saveguest ne "") {
					$yymain .= qq~</table>\n ~;
					$yymain .= qq~ <br>\n ~;
					$yymain .= qq~ <input type=reset value="$txt{'278'}">&nbsp;&nbsp;&nbsp;<input type=submit value="$txt{'417'}"> ~;
					$yymain .= qq~ </form>&nbsp;\n ~;
				}
				
				# Header
				$yymain .= qq~ <form action="$cgi;action=notify5" method=post> ~;
				$yymain .= qq~ <input name="guest_email" type="hidden" value="$guest_email"> ~;
				$yymain .= qq~ <table width="92%">\n ~;
				$yymain .= qq~ <tr><td colspan=2 class="catbg"><font size=2>$notify_txt{'63'} $guest_email</font></td></tr> ~;
				
				# Save Guest-email
				$saveguest = $guest_email;
			}
		
			&FormatUserName($found_username[$Arraynumber]);
			$yymain .= qq~ <tr><td><font size=2> ~;
			$yymain .= qq~ <input type=checkbox name="thread-$found_number[$Arraynumber]" value="1"></font></td> ~;
			$yymain .= qq~ <td><font size=2><b><i>$found_subject[$Arraynumber]</i></b> $txt{'525'} <a href="$scripturl?board=;action=viewprofile;username=$useraccount{$found_username[$Arraynumber]}">$found_name[$Arraynumber]</a></font></td></tr>\n ~;
			$yymain .= qq~ <td></td> ~;
			$yymain .= qq~ <td><font size="1">$notify_txt{'1'} $found_format[$Arraynumber]</font></td></tr> ~;
		}
	}

	$yymain .= qq~ </table>	~;
	
	# Show buttons only when notifications
	if (@found_number != 0) {

	$yymain .= qq~
	<br>
	<input type=reset value="$txt{'278'}">&nbsp;&nbsp;&nbsp;<input type=submit value="$txt{'417'}">
	</form>&nbsp;
~;
	}

$yymain .= qq~
   </font>
  </td>
 </tr>
</table>
~;
	$yytitle = "$notify_txt{'62'}";
	&template;
	exit;
}

1;